/*
 * Decompiled with CFR 0.152.
 */
package me.pieking1215.invmove;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import me.pieking1215.invmove.GsonHelperFix;
import me.pieking1215.invmove.InvMove;
import me.pieking1215.invmove.module.Module;
import me.pieking1215.invmove.module.config.ConfigBool;
import me.pieking1215.invmove.module.config.ConfigEnum;
import me.pieking1215.invmove.module.config.ModuleConfig;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_437;

public class InvMoveConfig {
    public static final Function<Boolean, class_2561> MOVEMENT_YES_NO_TEXT = b -> InvMove.instance().literalComponent(b != false ? String.valueOf(class_124.field_1060) + "Allow Movement" : String.valueOf(class_124.field_1061) + "Disallow Movement");
    public static final Function<Boolean, class_2561> BACKGROUND_YES_NO_TEXT = b -> InvMove.instance().literalComponent(b != false ? String.valueOf(class_124.field_1060) + "Hide Background" : String.valueOf(class_124.field_1061) + "Show Background");
    public static final General GENERAL = new General();
    public static final Movement MOVEMENT = new Movement();
    public static final Background BACKGROUND = new Background();

    public static class_437 setupCloth(class_437 parent) {
        SubCategoryBuilder cat;
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)InvMove.instance().translatableComponent("config.invmove.title"));
        builder.setDefaultBackgroundTexture(InvMove.instance().parseResource("minecraft:textures/block/spruce_planks.png"));
        builder.transparentBackground();
        ConfigEntryBuilder eb = builder.entryBuilder();
        ConfigCategory general = builder.getOrCreateCategory((class_2561)InvMove.instance().translatableComponent("key.invmove.category.general"));
        InvMoveConfig.GENERAL.cfg.addTo(general, eb, "config.invmove");
        ConfigCategory movement = builder.getOrCreateCategory((class_2561)InvMove.instance().translatableComponent("key.invmove.category.movement"));
        InvMoveConfig.MOVEMENT.cfg.addTo(movement, eb, "config.invmove");
        for (Module module : InvMove.instance().modules) {
            SubCategoryBuilder cat2 = eb.startSubCategory((class_2561)InvMove.instance().fromCV(module.getTitle()));
            module.getMovementConfig().addTo(cat2, eb, "config.invmove." + module.getId());
            movement.addEntry((AbstractConfigListEntry)cat2.build());
        }
        movement.addEntry((AbstractConfigListEntry)eb.startTextDescription((class_2561)InvMove.instance().translatableComponent("key.invmove.unrecognized").method_27692(class_124.field_1073)).build());
        if (InvMoveConfig.MOVEMENT.unrecognizedScreensAllowMovement.isEmpty()) {
            movement.addEntry((AbstractConfigListEntry)eb.startTextDescription((class_2561)InvMove.instance().translatableComponent("key.invmove.unrecognized.desc").method_27692(class_124.field_1080)).build());
        }
        for (String modid : InvMoveConfig.MOVEMENT.unrecognizedScreensAllowMovement.keySet()) {
            HashMap<Class<? extends class_437>, Boolean> screens = InvMoveConfig.MOVEMENT.unrecognizedScreensAllowMovement.get(modid);
            cat = eb.startSubCategory((class_2561)(modid.equals("?unknown") ? InvMove.instance().translatableComponent("key.invmove.unrecognized.nomod") : InvMove.instance().literalComponent(InvMove.instance().modNameFromModid(modid))));
            cat.setTooltip(new class_2561[]{InvMove.instance().literalComponent(String.valueOf(class_124.field_1080) + "modid: " + modid)});
            for (Class<? extends class_437> cl : screens.keySet()) {
                cat.add((AbstractConfigListEntry)eb.startBooleanToggle((class_2561)InvMove.instance().literalComponent(cl.getSimpleName()), screens.get(cl).booleanValue()).setTooltip(new class_2561[]{InvMove.instance().literalComponent(String.valueOf(class_124.field_1080) + cl.getName())}).setYesNoTextSupplier(MOVEMENT_YES_NO_TEXT).setSaveConsumer(v -> screens.put(cl, (Boolean)v)).build());
            }
            movement.addEntry((AbstractConfigListEntry)cat.build());
        }
        ConfigCategory background = builder.getOrCreateCategory((class_2561)InvMove.instance().translatableComponent("key.invmove.category.background"));
        InvMoveConfig.BACKGROUND.cfg.addTo(background, eb, "config.invmove");
        for (Module module : InvMove.instance().modules) {
            cat = eb.startSubCategory((class_2561)InvMove.instance().fromCV(module.getTitle()));
            module.getBackgroundConfig().addTo(cat, eb, "config.invmove." + module.getId());
            background.addEntry((AbstractConfigListEntry)cat.build());
        }
        background.addEntry((AbstractConfigListEntry)eb.startTextDescription((class_2561)InvMove.instance().translatableComponent("key.invmove.unrecognized").method_27692(class_124.field_1073)).build());
        if (InvMoveConfig.BACKGROUND.unrecognizedScreensHideBG.isEmpty()) {
            background.addEntry((AbstractConfigListEntry)eb.startTextDescription((class_2561)InvMove.instance().translatableComponent("key.invmove.unrecognized.desc").method_27692(class_124.field_1080)).build());
        }
        for (String modid : InvMoveConfig.BACKGROUND.unrecognizedScreensHideBG.keySet()) {
            HashMap<Class<? extends class_437>, Boolean> screens = InvMoveConfig.BACKGROUND.unrecognizedScreensHideBG.get(modid);
            SubCategoryBuilder cat3 = eb.startSubCategory((class_2561)(modid.equals("?unknown") ? InvMove.instance().translatableComponent("key.invmove.unrecognized.nomod") : InvMove.instance().literalComponent(InvMove.instance().modNameFromModid(modid))));
            cat3.setTooltip(new class_2561[]{InvMove.instance().literalComponent(String.valueOf(class_124.field_1080) + "modid: " + modid)});
            for (Class<? extends class_437> cl : screens.keySet()) {
                cat3.add((AbstractConfigListEntry)eb.startBooleanToggle((class_2561)InvMove.instance().literalComponent(cl.getSimpleName()), screens.get(cl).booleanValue()).setTooltip(new class_2561[]{InvMove.instance().literalComponent(String.valueOf(class_124.field_1080) + cl.getName())}).setSaveConsumer(v -> screens.put(cl, (Boolean)v)).setYesNoTextSupplier(BACKGROUND_YES_NO_TEXT).build());
            }
            background.addEntry((AbstractConfigListEntry)cat3.build());
        }
        return builder.setSavingRunnable(InvMoveConfig::save).build();
    }

    private static void moveOldConfig() {
        try {
            File configDir = InvMove.instance().configDir();
            if (configDir != null) {
                File invmoveConf;
                File invmoveConfOldForge;
                File invmoveDir = new File(configDir, "invMove/");
                if (invmoveDir.exists() && invmoveDir.getCanonicalPath().endsWith("invMove")) {
                    invmoveDir.renameTo(new File(invmoveDir.getParent(), "invMove_Old/"));
                }
                if ((invmoveConfOldForge = new File(configDir, "invmove-client.toml")).exists()) {
                    invmoveConfOldForge.renameTo(new File(configDir, "invmove-client_Old.toml"));
                }
                if ((invmoveConf = new File(configDir, "invmove.json")).exists()) {
                    JsonObject json;
                    JsonReader jr = new JsonReader((Reader)new FileReader(invmoveConf));
                    JsonElement jsonEl = (JsonElement)new Gson().fromJson(jr, JsonElement.class);
                    jr.close();
                    if (jsonEl != null && (json = jsonEl.getAsJsonObject()).has("uiBackground")) {
                        invmoveConf.renameTo(new File(configDir, "invmove_Old.json"));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        try {
            File configDir = InvMove.instance().configDir();
            if (configDir != null) {
                InvMoveConfig.moveOldConfig();
                File configFile = new File(configDir, "invmove.json");
                if (!configFile.exists()) {
                    configFile.getParentFile().mkdirs();
                    configFile.createNewFile();
                }
                if (configFile.exists()) {
                    InvMoveConfig.writeMainConfig(configFile);
                }
                for (Module module : InvMove.instance().modules) {
                    File modFile = new File(configDir, "invmove/" + module.getId() + ".json");
                    if (!modFile.exists()) {
                        modFile.getParentFile().mkdirs();
                        modFile.createNewFile();
                    }
                    if (!modFile.exists()) continue;
                    InvMoveConfig.writeModuleConfig(module, modFile);
                }
                File unrecognizedFile = new File(configDir, "invmove/unrecognized.json");
                if (!unrecognizedFile.exists()) {
                    unrecognizedFile.getParentFile().mkdirs();
                    unrecognizedFile.createNewFile();
                }
                if (unrecognizedFile.exists()) {
                    InvMoveConfig.writeUnrecognizedConfig(unrecognizedFile);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void load() {
        try {
            File configDir = InvMove.instance().configDir();
            if (configDir != null) {
                InvMoveConfig.moveOldConfig();
                File configFile = new File(configDir, "invmove.json");
                if (!configFile.exists()) {
                    configFile.getParentFile().mkdirs();
                    configFile.createNewFile();
                    if (configFile.exists()) {
                        InvMoveConfig.writeMainConfig(configFile);
                    }
                }
                if (configFile.exists()) {
                    InvMoveConfig.readMainConfig(configFile);
                }
                for (Module module : InvMove.instance().modules) {
                    File modFile = new File(configDir, "invmove/" + module.getId() + ".json");
                    if (!modFile.exists()) {
                        modFile.getParentFile().mkdirs();
                        modFile.createNewFile();
                        if (modFile.exists()) {
                            InvMoveConfig.writeModuleConfig(module, modFile);
                        }
                    }
                    if (!modFile.exists()) continue;
                    InvMoveConfig.readModuleConfig(module, modFile);
                }
                File unrecognizedFile = new File(configDir, "invmove/unrecognized.json");
                if (!unrecognizedFile.exists()) {
                    unrecognizedFile.getParentFile().mkdirs();
                    unrecognizedFile.createNewFile();
                    if (unrecognizedFile.exists()) {
                        InvMoveConfig.writeUnrecognizedConfig(unrecognizedFile);
                    }
                }
                if (unrecognizedFile.exists()) {
                    InvMoveConfig.readUnrecognizedConfig(unrecognizedFile);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeMainConfig(File file) throws IOException {
        JsonReader jr = new JsonReader((Reader)new FileReader(file));
        JsonElement jsonEl = (JsonElement)new Gson().fromJson(jr, JsonElement.class);
        jr.close();
        JsonObject json = jsonEl == null ? new JsonObject() : jsonEl.getAsJsonObject();
        InvMoveConfig.GENERAL.cfg.write(json);
        InvMoveConfig.MOVEMENT.cfg.write(json);
        InvMoveConfig.BACKGROUND.cfg.write(json);
        JsonWriter jw = new JsonWriter((Writer)new FileWriter(file));
        jw.setIndent("  ");
        new Gson().toJson((JsonElement)json, jw);
        jw.close();
    }

    private static void readMainConfig(File file) throws IOException {
        JsonReader jr = new JsonReader((Reader)new FileReader(file));
        JsonElement jsonEl = (JsonElement)new Gson().fromJson(jr, JsonElement.class);
        jr.close();
        if (jsonEl != null) {
            JsonObject json = jsonEl.getAsJsonObject();
            InvMoveConfig.GENERAL.cfg.read(json);
            InvMoveConfig.MOVEMENT.cfg.read(json);
            InvMoveConfig.BACKGROUND.cfg.read(json);
        }
    }

    private static void writeModuleConfig(Module mod, File file) throws IOException {
        JsonReader jr = new JsonReader((Reader)new FileReader(file));
        JsonElement jsonEl = (JsonElement)new Gson().fromJson(jr, JsonElement.class);
        jr.close();
        JsonObject json = jsonEl == null ? new JsonObject() : jsonEl.getAsJsonObject();
        mod.getMovementConfig().write(json);
        mod.getBackgroundConfig().write(json);
        JsonWriter jw = new JsonWriter((Writer)new FileWriter(file));
        jw.setIndent("  ");
        new Gson().toJson((JsonElement)json, jw);
        jw.close();
    }

    private static void readModuleConfig(Module mod, File file) throws IOException {
        JsonReader jr = new JsonReader((Reader)new FileReader(file));
        JsonElement jsonEl = (JsonElement)new Gson().fromJson(jr, JsonElement.class);
        jr.close();
        if (jsonEl != null) {
            JsonObject json = jsonEl.getAsJsonObject();
            mod.getMovementConfig().read(json);
            mod.getBackgroundConfig().read(json);
        }
    }

    private static void writeUnrecognizedConfig(File file) throws IOException {
        JsonReader jr = new JsonReader((Reader)new FileReader(file));
        JsonElement jsonEl = (JsonElement)new Gson().fromJson(jr, JsonElement.class);
        jr.close();
        JsonObject json = jsonEl == null ? new JsonObject() : jsonEl.getAsJsonObject();
        JsonObject movement = InvMoveConfig.getOrPutJsonObject(json, "allowMovement");
        for (String string : InvMoveConfig.MOVEMENT.unrecognizedScreensAllowMovement.keySet()) {
            HashMap<Class<? extends class_437>, Boolean> v = InvMoveConfig.MOVEMENT.unrecognizedScreensAllowMovement.get(string);
            for (Class<? extends class_437> cl : v.keySet()) {
                movement.addProperty(cl.getName(), v.get(cl));
            }
        }
        JsonObject background = InvMoveConfig.getOrPutJsonObject(json, "hideBackground");
        for (String modid : InvMoveConfig.BACKGROUND.unrecognizedScreensHideBG.keySet()) {
            HashMap<Class<? extends class_437>, Boolean> v = InvMoveConfig.BACKGROUND.unrecognizedScreensHideBG.get(modid);
            for (Class<? extends class_437> cl : v.keySet()) {
                background.addProperty(cl.getName(), v.get(cl));
            }
        }
        JsonWriter jsonWriter = new JsonWriter((Writer)new FileWriter(file));
        jsonWriter.setIndent("  ");
        new Gson().toJson((JsonElement)json, jsonWriter);
        jsonWriter.close();
    }

    private static void readUnrecognizedConfig(File file) throws IOException {
        JsonReader jr = new JsonReader((Reader)new FileReader(file));
        JsonElement jsonEl = (JsonElement)new Gson().fromJson(jr, JsonElement.class);
        jr.close();
        if (jsonEl != null) {
            JsonObject background;
            JsonObject json = jsonEl.getAsJsonObject();
            JsonObject movement = json.getAsJsonObject("allowMovement");
            if (movement != null) {
                for (Map.Entry entry : movement.entrySet()) {
                    if (!GsonHelperFix.isBooleanValue((JsonElement)entry.getValue())) continue;
                    try {
                        Class<?> cl = Class.forName((String)entry.getKey(), false, InvMoveConfig.class.getClassLoader());
                        if (!class_437.class.isAssignableFrom(cl)) continue;
                        String modid = InvMove.instance().modidFromClass(cl).orElse("?unknown");
                        InvMoveConfig.MOVEMENT.unrecognizedScreensAllowMovement.putIfAbsent(modid, new HashMap());
                        HashMap<Class<? extends class_437>, Boolean> hm = InvMoveConfig.MOVEMENT.unrecognizedScreensAllowMovement.get(modid);
                        hm.putIfAbsent(cl, ((JsonElement)entry.getValue()).getAsBoolean());
                    }
                    catch (ClassNotFoundException cl) {}
                }
            }
            if ((background = json.getAsJsonObject("hideBackground")) != null) {
                for (Map.Entry entry : background.entrySet()) {
                    if (!GsonHelperFix.isBooleanValue((JsonElement)entry.getValue())) continue;
                    try {
                        Class<?> cl = Class.forName((String)entry.getKey(), false, InvMoveConfig.class.getClassLoader());
                        if (!class_437.class.isAssignableFrom(cl)) continue;
                        String modid = InvMove.instance().modidFromClass(cl).orElse("?unknown");
                        InvMoveConfig.BACKGROUND.unrecognizedScreensHideBG.putIfAbsent(modid, new HashMap());
                        HashMap<Class<? extends class_437>, Boolean> hm = InvMoveConfig.BACKGROUND.unrecognizedScreensHideBG.get(modid);
                        hm.putIfAbsent(cl, ((JsonElement)entry.getValue()).getAsBoolean());
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
            }
        }
    }

    public static JsonObject getOrPutJsonObject(JsonObject parent, String id) {
        if (!GsonHelperFix.isObjectNode(parent, id)) {
            parent.add(id, (JsonElement)new JsonObject());
        }
        return parent.getAsJsonObject(id);
    }

    public static class General {
        public final ModuleConfig cfg = new ModuleConfig("general");
        public final ConfigBool ENABLED = this.cfg.bool("config.invmove.enable", "enable", true);
        public final ConfigBool DEBUG_DISPLAY = this.cfg.bool("config.invmove.debugDisplay", "debugDisplay", false);
    }

    public static class Movement {
        public final ModuleConfig cfg = new ModuleConfig("movement");
        public final ConfigBool ENABLED = this.cfg.bool("enable", true);
        public final ConfigBool JUMP = this.cfg.bool("jump", true);
        public final ConfigEnum<SneakMode> SNEAK = this.cfg.addEnum("sneak", SneakMode.Maintain).setMigrator(element -> GsonHelperFix.isBooleanValue(element) ? Optional.of(element.getAsBoolean() ? SneakMode.Pressed : SneakMode.Maintain) : Optional.empty());
        public final ConfigBool DISMOUNT = this.cfg.bool("dismount", false);
        public final ConfigBool TEXT_FIELD_DISABLES = this.cfg.bool("textFieldDisables", true);
        public final ConfigBool UNRECOGNIZED_SCREEN_DEFAULT = this.cfg.bool("unrecognizedScreenDefault", true).textFn(MOVEMENT_YES_NO_TEXT);
        public final HashMap<String, HashMap<Class<? extends class_437>, Boolean>> unrecognizedScreensAllowMovement = new HashMap();

        public static enum SneakMode {
            Off,
            Maintain,
            Pressed;

        }
    }

    public static class Background {
        public final ModuleConfig cfg = new ModuleConfig("background");
        public final ConfigBool BACKGROUND_HIDE = this.cfg.bool("enable", true);
        public final ConfigEnum<PauseScreenMode> HIDE_ON_PAUSE = this.cfg.addEnum("hideOnPause", PauseScreenMode.Show);
        public final ConfigBool UNRECOGNIZED_SCREEN_DEFAULT = this.cfg.bool("unrecognizedScreenDefault", true).textFn(BACKGROUND_YES_NO_TEXT);
        public final HashMap<String, HashMap<Class<? extends class_437>, Boolean>> unrecognizedScreensHideBG = new HashMap();

        public static enum PauseScreenMode {
            Show,
            ShowSP,
            AllowHide;

        }
    }
}

